/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class InfiltratingModifier
extends Modifier
implements ProjectileHitModifierHook {
    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        if (damage >= 2.0f) {
            return damage - 2.0f;
        }
        return 0.0f;
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.PROJECTILE_HIT);
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        LivingEntity holder = context.getAttacker();
        if (target != null) {
            for (ItemStack stackEquipment : target.m_6168_()) {
                Item item = stackEquipment.m_41720_();
                if (item instanceof ModifiableItem) {
                    ToolStack infoStack = ToolStack.from((ItemStack)stackEquipment);
                    ToolDamageUtil.damage((IToolStackView)infoStack, (int)10, (LivingEntity)holder, (ItemStack)stackEquipment);
                }
                if (!item.isDamageable(stackEquipment)) continue;
                item.damageItem(stackEquipment, 10, holder, null);
            }
        }
        return 0;
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (target != null) {
            for (ItemStack stackEquipment : target.m_6168_()) {
                Item item = stackEquipment.m_41720_();
                if (item instanceof ModifiableItem) {
                    ToolStack infoStack = ToolStack.from((ItemStack)stackEquipment);
                    ToolDamageUtil.damage((IToolStackView)infoStack, (int)10, (LivingEntity)attacker, (ItemStack)stackEquipment);
                }
                if (!item.isDamageable(stackEquipment)) continue;
                item.damageItem(stackEquipment, 10, attacker, null);
            }
        }
        return false;
    }
}

